﻿/// <reference name="MicrosoftAjax.js">

function checkAmounts() {
    var fromAmount = $find("FromCurrencyTextBox");
    var toAmount = $find("ToCurrencyTextBox");
    
    // using the unformatted values, reformat them into numbers and compare them.
    var unFormattedFrom = fromAmount.get_unFormattedValue();
    var unFormattedTo = toAmount.get_unFormattedValue();
    
    // make sure the values are set.
    var formattedFrom = null;
    var formattedTo = null;
    
    if (unFormattedFrom !== null && unFormattedFrom !== "") {
        formattedFrom = Number.parseLocale(unFormattedFrom);
        if (isNaN(formattedFrom)) {
            alert (String.format(Filter.Res.InvalidCurrencyFilterMessage, Filter.Res.FromAmount));
            return false;
        }
    }
    
    if (unFormattedTo !== null && unFormattedTo !== "") {
        formattedTo = Number.parseLocale(unFormattedTo);
        if (isNaN(formattedTo))
        {
            alert (String.format(Filter.Res.InvalidCurrencyFilterMessage, Filter.Res.ToAmount));
            return false;
        }
    }
        
    // make sure they are both valid dates
    if (formattedFrom !== null && formattedTo !== null) {
        if (formattedFrom > formattedTo) {
            alert (Filter.Res.FromAmountGreaterThanToAmountMessage);
            return false;
        }
    }
  
    return true;
}

Type.registerNamespace("Filter");
Filter.Res = {
    FromAmount: "De la Quantité",
    InvalidCurrencyFilterMessage: "Le filtre ne peut pas être appliqué parce que '{0} 'n'est pas un nombre valide.",
    ToAmount: "À la Quantité",
    FromAmountGreaterThanToAmountMessage: "De la quantité doit être inférieur ou égal à pour s'élever."
}